/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.tan;

import com.google.common.eventbus.Subscribe;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.plugins.tan.FillCanteenRecipe;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="ToughAsNailsPlugin", description="Adds support between TAN thirst and the cauldron overrides", modsRequired="toughasnails", pulsesRequired="InspirationsRecipes")
public class ToughAsNailsPlugin
extends PulseBase {
    public static final String pulseID = "ToughAsNailsPlugin";
    @GameRegistry.ObjectHolder(value="toughasnails:purified_water_bottle")
    public static final Item waterBottle = null;
    @GameRegistry.ObjectHolder(value="toughasnails:charcoal_filter")
    public static final Item charcoalFilter = null;
    @GameRegistry.ObjectHolder(value="toughasnails:fruit_juice")
    public static final Item fruitJuice = null;
    @GameRegistry.ObjectHolder(value="toughasnails:canteen")
    public static final Item canteen = null;
    public static Fluid sweetenedWater;
    public static Fluid[] juices;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (!Config.enableExtendedCauldron) {
            return;
        }
        if (Config.tanJuiceInCauldron) {
            sweetenedWater = ToughAsNailsPlugin.registerColoredFluid("sweetened_water", -13259534);
            juices = new Fluid[]{ToughAsNailsPlugin.registerColoredFluid("apple_juice", -279996), ToughAsNailsPlugin.registerColoredFluid("beetroot_juice", -5631450), ToughAsNailsPlugin.registerColoredFluid("cactus_juice", -8408259), ToughAsNailsPlugin.registerColoredFluid("carrot_juice", -2792660), ToughAsNailsPlugin.registerColoredFluid("chorus_fruit_juice", -6069837), ToughAsNailsPlugin.registerColoredFluid("glistering_melon_juice", -47289), ToughAsNailsPlugin.registerColoredFluid("golden_apple_juice", -25271), ToughAsNailsPlugin.registerColoredFluid("golden_carrot_juice", -37290), ToughAsNailsPlugin.registerColoredFluid("melon_juice", -3327949), ToughAsNailsPlugin.registerColoredFluid("pumpkin_juice", -3242959)};
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (!Config.enableExtendedCauldron) {
            return;
        }
        Fluid purifiedWater = FluidRegistry.getFluid((String)"purified_water");
        if (purifiedWater != null) {
            InspirationsRegistry.addCauldronWater(purifiedWater);
            if (waterBottle != null) {
                InspirationsRegistry.addCauldronFluidItem(new ItemStack(waterBottle, 1), new ItemStack(Items.field_151069_bo), purifiedWater);
            }
            if (charcoalFilter != null) {
                InspirationsRegistry.addCauldronScaledTransformRecipe(new ItemStack(charcoalFilter), FluidRegistry.WATER, purifiedWater, null);
            }
            if (canteen != null) {
                for (int i = 0; i < 3; ++i) {
                    InspirationsRegistry.addCauldronRecipe(new FillCanteenRecipe(canteen, i, 1, FluidRegistry.WATER));
                    InspirationsRegistry.addCauldronRecipe(new FillCanteenRecipe(canteen, i, 2, purifiedWater));
                }
                InspirationsRegistry.addCauldronBlacklist(canteen, Short.MAX_VALUE);
            }
            if (Config.tanJuiceInCauldron && fruitJuice != null) {
                InspirationsRegistry.addCauldronScaledTransformRecipe(new ItemStack(Items.field_151102_aT), purifiedWater, sweetenedWater, null);
                Item[] items = new Item[]{Items.field_151034_e, Items.field_185164_cV, Item.func_150898_a((Block)Blocks.field_150434_aF), Items.field_151172_bF, Items.field_185161_cS, Items.field_151060_bw, Items.field_151153_ao, Items.field_151150_bK, Items.field_151127_ba, Item.func_150898_a((Block)Blocks.field_150423_aK)};
                for (int i = 0; i < items.length; ++i) {
                    ToughAsNailsPlugin.addJuiceRecipe(juices[i], i, items[i]);
                }
            }
        } else {
            Inspirations.log.error("Unable to find Tough as Nails purified water fluid, skipping recipes");
        }
    }

    private static void addJuiceRecipe(Fluid fluid, int meta, Item ingredient) {
        InspirationsRegistry.addCauldronScaledTransformRecipe(new ItemStack(ingredient), sweetenedWater, fluid, null);
        InspirationsRegistry.addCauldronFluidItem(new ItemStack(fruitJuice, 1, meta), new ItemStack(Items.field_151069_bo), fluid);
    }
}

